<!--
BOSCH Security Systems (Grasbrunn)
Project: Magic.Panel
Author: Michael Ziegel
Created: 13-07-2010
$Revision: 1.3 $ 
Last locked:   $Date: 2010/07/13 14:16:42GMT $
Last change by $Author: Michael Ziegel (zi82ot) $
History: 
$Log: XSLT/counter-2-x.xsl  $
Revision 1.3 2010/07/13 14:16:42GMT Michael Ziegel (zi82ot) 
Member moved from Conversion/XSLT/counter-2-x.xsl in project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Transformer/Transformer.pj to XSLT/counter-2-x.xsl in project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/RPSTools/XMLSupport/XMLSupport.pj.
Revision 1.2 2010/07/13 16:16:42CEST Michael Ziegel (zi82ot) 
test /CONFIGURATION
Revision 1.1 2010/07/13 13:54:52CEST Michael Ziegel (zi82ot) 
Initial revision
Member added to project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Transformer/Transformer.pj
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cfg=".">
   <cfg:Stylesheet version="$Revision: 1.3 $"/>
   <xsl:output method="xml" encoding="UTF-8" indent="yes"/>
   <!--****************** BEGIN COUNTER RELATED in 2.x ***********************************************************-->
   <!-- remove triggerNet and triggerPanel -->
   <xsl:template match="TRIGGER_COUNTER">
      <xsl:element name="TRIGGER_COUNTER">
         <xsl:element name="triggerSubject">
            <xsl:value-of select="triggerSubject"/>
         </xsl:element>
         <xsl:element name="triggerNumber">
            <xsl:choose>
               <!--  If the root is 'CONFIGURATION' it is a 1.x config.
                    In this case all counter-numbers references greater than 3 have to be incremented by 2, because the counter-numbers greater than 4 are shifted
                    by 2 in the list of COUNTER_ADMIN -->
               <xsl:when test="triggerNumber &gt; 3 and /CONFIGURATION = true()">
                  <xsl:value-of select="number(triggerNumber) + 2"/>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="triggerNumber"/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:element>
         <xsl:element name="threshold">
            <xsl:value-of select="threshold"/>
         </xsl:element>
         <xsl:element name="condition">
            <xsl:value-of select="condition"/>
         </xsl:element>
      </xsl:element>
   </xsl:template>
   <!-- -->
   <xsl:template match="CONDITION_COUNTER">
      <xsl:element name="CONDITION_COUNTER">
         <xsl:element name="conditionNumber">
            <!-- BEGIN this part is added for version 2.0.3 -->
            <xsl:choose>
               <!-- if CONDITION_COUNTER is under CITYTIE configured the counter 1 (fire) is replaced by FIRE_SCOPE -->
               <xsl:when test="conditionNumber = '1' and ancestor::CITYTIE = true()">
                  <xsl:text>FIRE_SCOPE</xsl:text>
               </xsl:when>
               <!-- if CONDITION_COUNTER is under SET 32 -->
               <xsl:when test="ancestor::SET/siType  = 'MP_SI_OUTPUT_GROUP' and ancestor::SET/siNumber = '32' and preceding-sibling::TRIGGER_USER/command = 'MP_CMD_LOGOFF' and preceding-sibling::TRIGGER_USER/userId = '9'">
                  <xsl:text>FIRE_SCOPE</xsl:text>
               </xsl:when>
               <!--  If the root is 'CONFIGURATION' it is a 1.x config. 
                    In this case all counter-numbers references greater than 3 have to be incremented by 2, because the counter-numbers greater than 4 are shifted
                    by 2 in the list of COUNTER_ADMIN -->
               <xsl:when test="conditionNumber &gt; 3 and /CONFIGURATION = true()">
                  <xsl:value-of select="number(conditionNumber) + 2"/>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="conditionNumber"/>
               </xsl:otherwise>
            </xsl:choose>
            <!-- END this part is added for version 2.0.3 -->
         </xsl:element>
         <xsl:element name="threshold">
            <xsl:value-of select="threshold"/>
         </xsl:element>
         <xsl:element name="comparator">
            <xsl:value-of select="comparator"/>
         </xsl:element>
      </xsl:element>
   </xsl:template>
   <!-- Add new default counters to COUNTER_ADMIN -->
   <xsl:template match="COUNTER_ADMIN">
      <xsl:element name="{name()}">
         <xsl:for-each select="*">
            <xsl:choose>
               <xsl:when test="siNumber = 3">
                  <xsl:apply-templates select="."/>
                  <xsl:choose>
                     <xsl:when test="/CONFIGURATION = true()">
                        <xsl:call-template name="AddDefaultCounters"/>
                     </xsl:when>
                  </xsl:choose>
               </xsl:when>
               <xsl:when test="siNumber &gt; 3 and /CONFIGURATION = true()">
                  <xsl:call-template name="MoveUserCounters">
                     <xsl:with-param name="SiNumber" select="siNumber"/>
                     <xsl:with-param name="CounterName" select="name(.)"/>
                  </xsl:call-template>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:apply-templates select="."/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:for-each>
      </xsl:element>
   </xsl:template>
   <!-- move existing counters after the two added default-counters increment siNumber of each by two-->
   <xsl:template name="MoveUserCounters">
      <xsl:param name="SiNumber"/>
      <xsl:param name="CounterName"/>
      <xsl:element name="{$CounterName}">
         <xsl:for-each select="*">
            <xsl:choose>
               <xsl:when test="name(.) = 'siNumber'">
                  <xsl:element name="siNumber">
                     <xsl:value-of select="$SiNumber + 2"/>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:apply-templates select="."/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:for-each>
      </xsl:element>
   </xsl:template>
   <!-- -->
   <!-- these two counters are added in all 2.x configs, it was done by RPS in V2.0.51 automatically, after 2.0.51 it was not done by RPS -->
   <xsl:template name="AddDefaultCounters">
      <xsl:element name="COUNTER">
         <xsl:element name="siNumber">4</xsl:element>
         <xsl:element name="label">Counter Power-Fail/Stromausfall</xsl:element>
         <xsl:element name="cstate">MP_ET_POWERFAIL</xsl:element>
         <xsl:element name="condition">EQ</xsl:element>
         <xsl:element name="subject">MP_SI_ANY</xsl:element>
         <xsl:element name="subjectNumber">*</xsl:element>
         <xsl:element name="subjectSubNumber">*</xsl:element>
         <xsl:element name="isRemote">ST_NO</xsl:element>
      </xsl:element>
      <xsl:element name="SUMCOUNTER">
         <xsl:element name="siNumber">5</xsl:element>
         <xsl:element name="label">All Troubles / Alle Stoerungen</xsl:element>
         <xsl:element name="counter">2</xsl:element>
         <xsl:element name="counter">4</xsl:element>
      </xsl:element>
   </xsl:template>
   <!-- increase counter-numbers  greater than 3 used in SUMCOUNTERS by 2-->
   <!-- remove leading group.node from counter number -->
   <xsl:template match="SUMCOUNTER/counter">
      <xsl:element name="counter">
         <xsl:variable name="Countervalue">
            <xsl:choose>
               <xsl:when test="contains(.,'.') = true()">
                  <xsl:value-of select="substring-after(substring-after(.,'.'),'.')"/>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="."/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:variable>
         <xsl:choose>
            <xsl:when test="$Countervalue &gt; 3 and /CONFIGURATION = true()">
               <xsl:value-of select="number($Countervalue) +2"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="$Countervalue"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:element>
   </xsl:template>
   <!-- add element isRemote to COUNTER -->
   <xsl:template match="COUNTER">
      <xsl:element name="{name()}">
         <xsl:for-each select="*">
            <xsl:choose>
               <xsl:when test="name()='subjectSubNumber' and .=''">
                  <xsl:element name="{name()}">
                     <xsl:text>0</xsl:text>
                  </xsl:element>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:apply-templates select="."/>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:for-each>
         <xsl:if test="isRemote = false()">
            <xsl:element name="isRemote">
               <xsl:choose>
                  <xsl:when test="number(subjectNumber) >= 55000">
                     <xsl:text>ST_YES</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:text>ST_NO</xsl:text>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:element>
         </xsl:if>
      </xsl:element>
   </xsl:template>
   <!--****************** END COUNTER RELATED in 2.x ***********************************************************-->
</xsl:stylesheet>
